package io.openems.edge.meter.artemes.am2;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.common.types.MeterType;

@ObjectClassDefinition(name = "Meter Artemes AM-2", description = "Implements the Artemes AM-2 meter.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "meter0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Meter-Type", description = "Grid, Production (=default), Consumption")
	MeterType type() default MeterType.PRODUCTION;

	@AttributeDefinition(name = "Modbus-ID", description = "Id of the modbus bridge")
	String modbus_id();

	@AttributeDefinition(name = "Modbus Unit-ID", description = "The Unit-ID of the Modbus device")
	int modbusUnitId();

	@AttributeDefinition(name = "Invert", description = "Should the meter values be inverted?")
	boolean invert() default false;

	@AttributeDefinition(name = "Modbus target filter", description = " This is auto-generated by 'Modbus-ID'")
	String Modbus_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Meter Artemes AM-2 [{id}]";

}