package io.openems.edge.kostal.plenticore.gridmeter;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.common.types.MeterType;

@ObjectClassDefinition(name = "KOSTAL Smart Energy Meter (KSEM)", //
		description = "Implements the Kostal Smart Energy Meter (KSEM)")
@interface Config {
	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "meter0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Modbus-ID", description = "ID of Modbus bridge.")
	String modbus_id() default "modbus0";

	@AttributeDefinition(name = "Modbus Unit-ID", description = "The Unit-ID of the Modbus device. ")
	int modbusUnitId() default 71;

	@AttributeDefinition(name = "Inverter-based", description = "read via inverter")
	boolean viaInverter() default false;

	@AttributeDefinition(name = "Word-wrap", description = "using word-wrapped conversion")
	boolean wordwrap() default false;

	@AttributeDefinition(name = "Modbus target filter", description = "This is auto-generated by 'Modbus-ID'.")
	String Modbus_target() default "(enabled=true)";

	@AttributeDefinition(name = "Meter-Type", description = "What is measured by this Meter?")
	MeterType type() default MeterType.GRID;

	String webconsole_configurationFactory_nameHint() default "KOSTAL Smart Energy Meter (KSEM) [{id}]";
}
