package io.openems.edge.kaco.blueplanet.hybrid10.pvinverter;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "KACO blueplanet hybrid 10.0 TL3 PV-Inverter", //
		description = "Implements the PV-Inverter component for KACO blueplanet hybrid 10.0 TL3")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "pvInverter0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Core-ID", description = "ID of Core component")
	String core_id() default "kacoCore0";

	@AttributeDefinition(name = "Core target filter", description = "This is auto-generated by 'Core-ID'")
	String core_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "KACO blueplanet hybrid 10.0 TL3 PV-Inverter [{id}]";
}
