package io.openems.edge.goodwe.ess;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.goodwe.GoodWeConstants;
import io.openems.edge.goodwe.common.enums.ControlMode;

@ObjectClassDefinition(//
		name = "GoodWe ESS", //
		description = "Implements the GoodWe ET Energy Storage System.")

@interface Config {
	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ess0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Control mode", description = "Sets the Control mode")
	ControlMode controlMode() default ControlMode.INTERNAL;

	@AttributeDefinition(name = "Modbus-ID", description = "ID of Modbus bridge.")
	String modbus_id() default "modbus0";

	@AttributeDefinition(name = "Modbus Unit-ID", description = "The Unit-ID of the Modbus device.")
	int modbusUnitId() default GoodWeConstants.DEFAULT_UNIT_ID;

	@AttributeDefinition(name = "Capacity", description = "Capacity of the battery in [Wh]")
	int capacity() default 9_000;

	@AttributeDefinition(name = "Maximum power", description = "Maximum charge/discharge power in [W]")
	int maxBatteryPower() default 5_200;

	@AttributeDefinition(name = "Modbus target filter", description = "This is auto-generated by 'Modbus-ID'.")
	String Modbus_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "GoodWe ESS [{id}]";
}
