package io.openems.edge.goodwe.batteryinverter;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.common.startstop.StartStopConfig;
import io.openems.edge.goodwe.GoodWeConstants;
import io.openems.edge.goodwe.common.enums.ControlMode;
import io.openems.edge.goodwe.common.enums.EnableDisable;
import io.openems.edge.goodwe.common.enums.FeedInPowerSettings;
import io.openems.edge.goodwe.common.enums.GridCode;
import io.openems.edge.goodwe.common.enums.SafetyCountry;

@ObjectClassDefinition(//
		name = "GoodWe Battery-Inverter", //
		description = "GoodWe Battery Inverter.")

@interface Config {
	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "batteryInverter0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Start/stop behaviour?", description = "Should this Component be forced to start or stop?")
	StartStopConfig startStop() default StartStopConfig.AUTO;

	@AttributeDefinition(name = "Control mode", description = "Sets the Control mode")
	ControlMode controlMode() default ControlMode.SMART;

	@AttributeDefinition(name = "Modbus-ID", description = "ID of Modbus bridge.")
	String modbus_id() default "modbus0";

	@AttributeDefinition(name = "Modbus Unit-ID", description = "The Unit-ID of the Modbus device.")
	int modbusUnitId() default GoodWeConstants.DEFAULT_UNIT_ID;

	@AttributeDefinition(name = "Modbus target filter", description = "This is auto-generated by 'Modbus-ID'.")
	String Modbus_target() default "(enabled=true)";

	@AttributeDefinition(name = "Country Setting", description = "Selection of feed in country")
	SafetyCountry safetyCountry() default SafetyCountry.GERMANY;

	@AttributeDefinition(name = "Enable/disable MPPT Shadow Management", description = "Enable/disable shadow management of MTTP")
	EnableDisable mpptForShadowEnable() default EnableDisable.ENABLE;

	@AttributeDefinition(name = "Enable/disable Off-Grid outlet", description = "Enable/disable Off-Grid outlet")
	EnableDisable backupEnable() default EnableDisable.ENABLE;

	@Deprecated
	@AttributeDefinition(name = "Enable/disable Dynamic Feed-To-Grid Limit", description = "Enable/disable a Feed-To-Grid limit for dynamic limitation at the grid meter. (deprecated, use=Meta#gridFeedInLimitationType)")
	EnableDisable feedPowerEnable() default EnableDisable.DISABLE;

	@Deprecated
	@AttributeDefinition(name = "Feed-To-Grid Power Limit", description = "Feed-To-Grid Power Limit (Only positive [0 - 29999]) (deprecated, use=Meta#maximumGridFeedInLimit)")
	int feedPowerPara() default 0;

	@AttributeDefinition(name = "Feed-To-Grid Settings", description = "This is the selection of inverter power settings")
	FeedInPowerSettings setfeedInPowerSettings() default FeedInPowerSettings.UNDEFINED;

	@AttributeDefinition(name = "GridCode Setting", description = "GridCode Setting e.g. VDE-AR-N 4105 for germay.")
	GridCode gridCode() default GridCode.VDE_4105;

	@AttributeDefinition(name = "Enable/disable Ripple Control Receiver", description = "Enable/disable Ripple Control Receiver (RCR) function")
	EnableDisable rcrEnable() default EnableDisable.DISABLE;

	@AttributeDefinition(name = "Enable/disable NA-protection", description = "Enable/disable NA-protection")
	EnableDisable naProtectionEnable() default EnableDisable.DISABLE;

	String webconsole_configurationFactory_nameHint() default "GoodWe Battery Inverter [{id}]";
}
