package io.openems.edge.fenecon.mini.ess;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.common.type.Phase.SinglePhase;

@ObjectClassDefinition(//
		name = "FENECON Mini ESS", //
		description = "The energy storage system implementation of a FENECON Mini.")
public @interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ess0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Read-Only mode", description = "Enables Read-Only mode")
	boolean readonly() default true;

	@AttributeDefinition(name = "Phase", description = "On which Phase is the Mini connected?")
	SinglePhase phase() default SinglePhase.L1;

	@AttributeDefinition(name = "Modbus-ID", description = "ID of Modbus bridge.")
	String modbus_id() default "modbus0";

	@AttributeDefinition(name = "Modbus target filter", description = "This is auto-generated by 'Modbus-ID'.")
	String Modbus_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "FENECON Mini ESS [{id}]";
}