package io.openems.edge.evcs.webasto.unite;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name = "EVCS Webasto Unite", description = "Implements the Webasto Unite electric vehicle charging station.")
@interface Config {

	@AttributeDefinition(name = "Component-Id", description = "Unique Id for the EVCS.")
	String id() default "evcs0";

	@AttributeDefinition(name = "Alias", description = "Human readable name of this EVCS.")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Modbus-ID", description = "ID of Modbus bridge.")
	String modbus_id() default "modbus0";

	@AttributeDefinition(name = "Modbus Unit-ID", description = "The Unit-ID of the Modbus device.")
	int modbusUnitId() default 255;

	@AttributeDefinition(name = "Minimum Current", description = "Minimum current of the Charger in mA.", required = true)
	int minHwCurrent() default 6000;

	@AttributeDefinition(name = "Maximum Current", description = "Maximum current of the Charger in mA.", required = true)
	int maxHwCurrent() default 32000;

	@AttributeDefinition(name = "Debug Mode", description = "Activates the debug mode")
	boolean debugMode() default false;

	@AttributeDefinition(name = "Modbus target filter", description = "This is auto-generated by 'Modbus-ID'.")
	String Modbus_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "EVCS Webasto Unite [{id}]";
}