package io.openems.edge.evcs.goe.modbus;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.meter.api.PhaseRotation;

@ObjectClassDefinition(//
        name = "EVCS go-e Gemini Modbus", //
        description = "Unstable implementation for the go-e Gemini charging station using Modbus. The HTTP implementation is generally preferred.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "evcs0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Modbus-ID", description = "ID of Modbus bridge.")
	String modbus_id() default "modbus0";

	@AttributeDefinition(name = "Modbus Unit-ID", description = "The Unit-ID of the Modbus device.")
	int modbusUnitId() default 1;

	@AttributeDefinition(name = "Modbus target filter", description = "This is auto-generated by 'Modbus-ID'.")
	String Modbus_target() default "(enabled=true)";

	@AttributeDefinition(name = "Minimum hardware current", description = "Minimum charging current of the Charger in mA.", required = true)
	int minHwCurrent() default 6_000;

	@AttributeDefinition(name = "Maximum hardware current", description = "Maximum charging current of the Charger in mA.", required = true)
	int maxHwCurrent() default 32_000;

	@AttributeDefinition(name = "Phase rotation", description = "The way in which the phases are physically rotated.")
    PhaseRotation phaseRotation() default PhaseRotation.L1_L2_L3;

	@AttributeDefinition(name = "Read only", description = "Defines that this evcs is read only.", required = true)
	boolean readOnly() default true;

	String webconsole_configurationFactory_nameHint() default "EVCS go-e Gemini [{id}]";

}