package io.openems.edge.controller.symmetric.balancingschedule;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "Controller Balancing Schedule Symmetric", //
		description = "Controls an ESS with the target to keep the grid-meter on a value defined in a Schedule.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlBalancingSchedule0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Ess-ID", description = "ID of Ess device.")
	String ess_id();

	@AttributeDefinition(name = "Grid-Meter-ID", description = "ID of the Grid-Meter.")
	String meter_id();

	@AttributeDefinition(name = "Schedule", description = "The Schedule as a JSON-Array")
	String schedule() default "";

	@AttributeDefinition(name = "Ess target filter", description = "This is auto-generated by 'Ess-ID'.")
	String ess_target() default "(enabled=true)";

	@AttributeDefinition(name = "Grid-Meter target filter", description = "This is auto-generated by 'Grid-Meter-ID'.")
	String meter_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Balancing Schedule Symmetric [{id}]";
}