package io.openems.edge.controller.io.heating.room;

import io.openems.common.types.OptionsEnum;

public enum Mode implements OptionsEnum {
	OFF(0, "Off"), //
	MANUAL_LOW(1, "Manual Low"), //
	MANUAL_HIGH(2, "Manual High"), //
	AUTOMATIC(3, "Automatic schedule control"); //

	private final int value;
	private final String name;

	private Mode(int value, String name) {
		this.value = value;
		this.name = name;
	}

	@Override
	public int getValue() {
		return this.value;
	}

	@Override
	public String getName() {
		return this.name;
	}

	@Override
	public OptionsEnum getUndefined() {
		return OFF;
	}
}