package io.openems.edge.controller.io.analog;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "Controller IO Analog", //
		description = "This Controller sets a analog output according to the configured inputs.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlIoAnalog0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Mode", description = "Set the type of mode.")
	Mode mode() default Mode.AUTOMATIC;

	@AttributeDefinition(name = "AnalogOutput-ID", description = "ID of the AnalogOutput")
	String analogOutput_id() default "analogIo0";

	@AttributeDefinition(name = "Target", description = "Target")
	int manualTarget() default 0;

	@AttributeDefinition(name = "Maximum power", description = "Maximum power of the hardware device.")
	int maximumPower() default 12_000;

	@AttributeDefinition(name = "Power behaviour", description = "Power output of the Device is behaving linear or non-linear (leading/trailing edge)")
	PowerBehavior powerBehaviour() default PowerBehavior.LINEAR;

	@AttributeDefinition(name = "AnalogOutput target filter", description = "This is auto-generated by 'AnalogOutput-ID'.")
	String analogOutput_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller IO Analog [{id}]";

}