package io.openems.edge.controller.evse.single;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.evse.api.chargepoint.Mode;

@ObjectClassDefinition(//
		name = "EVSE Controller Single Charge-Point", //
		description = "Controls a single EVSE Charge-Point")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlEvseSingle0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Mode", description = "Set the mode")
	Mode mode() default Mode.ZERO;

	@AttributeDefinition(name = "Charge-Point-ID", description = "ID of EVSE Charge-Point", required = true)
	String chargePoint_id() default "evseChargePoint0";

	@AttributeDefinition(name = "Electric-Vehicle-ID", description = "ID of EVSE Electric-Vehicle.")
	String electricVehicle_id() default "evseElectricVehicle0";

	@AttributeDefinition(name = "Phase-Switching", description = "The Phase-Switching configuration.")
	PhaseSwitching phaseSwitching() default PhaseSwitching.DISABLE;

	// TODO implement
	@AttributeDefinition(name = "Smart mode: JSON Configuration", description = "")
	String smartConfig() default "";

	@AttributeDefinition(name = "Manual mode: Session Energy limit in [Wh]", description = "The charging station will only charge till this limit; '0' is no limit.")
	int manualEnergySessionLimit() default 0;

	@AttributeDefinition(name = "Log-Verbosity", description = "The log verbosity.")
	LogVerbosity logVerbosity() default LogVerbosity.DEBUG_LOG;

	@AttributeDefinition(name = "Charge-Point target filter", description = "This is auto-generated by 'Charge-Point-ID'.")
	String chargePoint_target() default "(enabled=true)";

	@AttributeDefinition(name = "Electric-Vehicle target filter", description = "This is auto-generated by 'Electric-Vehicle-ID'.")
	String electricVehicle_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller EVSE: Single Charge-Point [{id}]";

}
