package io.openems.edge.controller.evse.cluster;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "EVSE Controller Cluster of Charge-Points", //
		description = "Controls multiple EVSE Charge-Point-Controllers")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlEvseCluster0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Distribution Strategy", description = "How should power be distributed in Surplus-Mode?")
	DistributionStrategy distributionStrategy() default DistributionStrategy.EQUAL_POWER;

	@AttributeDefinition(name = "Debug Mode", description = "Activates the debug mode")
	boolean debugMode() default false;

	@AttributeDefinition(name = "Charge-Point-Controller-IDs", description = "IDs of EVSE Charge-Point-Controllers", required = true)
	String[] ctrl_ids() default { "ctrlEvseSingle0" };

	@AttributeDefinition(name = "Charge-Point-Controllers target filter", description = "This is auto-generated by 'Charge-Point-Controller-IDs'.")
	String ctrls_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller EVSE: Cluster of Charge-Points [{id}]";
}
