package io.openems.edge.controller.ess.hybrid.surplusfeedtogrid;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "Controller Ess Hybrid Surplus-Feed-To-Grid", //
		description = "Feeds surplus power of a hybrid inverter to grid.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlEssSurplusFeedToGrid0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Ess-ID", description = "ID of Hybrid Ess device.")
	String ess_id() default "ess0";

	@AttributeDefinition(name = "Ess target filter", description = "This is auto-generated by 'Ess-ID'.")
	String ess_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Ess Hybrid Surplus-Feed-To-Grid [{id}]";

}
