package io.openems.edge.controller.ess.fastfrequencyreserve;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.controller.ess.fastfrequencyreserve.enums.ControlMode;

@ObjectClassDefinition(//
		name = "Controller Ess Fast Frequency Reserve", //
		description = "This Controller helps the energy storage system (ESS) generate capacity, essentially battery discharge. When the measured\n"
				+ "\"Grid frequency\" is lower than the predefined \"Frequency limit\".") //
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlFastFreqReserve0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Control Mode", description = "Set the type of control mode.")
	ControlMode controlMode() default ControlMode.MANUAL_OFF;

	@AttributeDefinition(name = "Activation Schdule", description = "Schedule for the activation.")
	String activationScheduleJson() default "[\n" //
			+ "    {\n" //
			+ "        \"startTimestamp\": 1684879200,\n" //
			+ "        \"duration\": 86400,\n" //
			+ "        \"dischargePowerSetPoint\": 92000,\n" //
			+ "        \"frequencyLimit\": 49500,\n" //
			+ "        \"activationRunTime\": \"LONG_ACTIVATION_RUN\",\n" //
			+ "        \"supportDuration\": \"LONG_SUPPORT_DURATION\"\n" //
			+ "    }\n" //
			+ "]"; //

	@AttributeDefinition(name = "Ess-ID", description = "ID of Ess device.")
	String ess_id();

	@AttributeDefinition(name = "Grid-Meter-Id", description = "ID of the Grid-Meter.")
	String meter_id();

	@AttributeDefinition(name = "Pre activation time", description = "A time before the activation time for charging the system(min).")
	int preActivationTime() default 0;

	@AttributeDefinition(name = "Ess target filter", description = "This is auto-generated by 'Ess-ID'.")
	String ess_target() default "(enabled=true)";

	@AttributeDefinition(name = "Meter target filter", description = "This is auto-generated by 'Grid-Meter-ID'.")
	String meter_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Ess Fast Frequency Reserve [{id}]";
}