package io.openems.edge.controller.ess.emergencycapacityreserve;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "Controller Ess Emergency Capacity Reserve", //
		description = "Delays/stops discharging if SoC is at configured reserve SoC")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlEmergencyCapacityReserve0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Ess-ID", description = "ID of Ess device.")
	String ess_id() default "ess0";

	@AttributeDefinition(name = "Reserve SoC", description = "Reserve value for battery SoC")
	int reserveSoc() default 10;

	@AttributeDefinition(name = "Mode", description = "Set controller ON or OFF")
	boolean isReserveSocEnabled() default true;

	@AttributeDefinition(name = "Ess target filter", description = "This is auto-generated by 'Ess-ID'.")
	String ess_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Ess Emergency Capacity Reserve [{id}]";

}