package io.openems.edge.controller.ess.cycle;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "Controller Ess Cycle", //
		description = "Completes cycles for an Ess.")
public @interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlEssCycle0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Mode", description = "Set the type of mode.")
	Mode mode() default Mode.MANUAL_ON;

	@AttributeDefinition(name = "Ess-ID", description = "ID of Ess device.")
	String ess_id() default "ess0";

	@AttributeDefinition(name = "CycleOrder [Charge/Discharge]", description = "Charge/discharge CycleOrder for Operation")
	CycleOrder cycleOrder() default CycleOrder.START_WITH_DISCHARGE;

	@AttributeDefinition(name = " Standby Time in Minute", description = "Wait Between Charge and Discharge (Just Integer in time minute).")
	int standbyTime() default 30;

	@AttributeDefinition(name = "Start Time in Hour [YYYY-MM-DD HH:MM]", description = "Start Charge/Discharge Hour (2023-03-23 15:35).")
	String startTime() default "2000-01-01 01:00";

	@AttributeDefinition(name = "Maximum Soc [%]", description = "Limit Charge")
	int maxSoc() default 100;

	@AttributeDefinition(name = "Minimum Soc [%]", description = "Limit Discharge")
	int minSoc() default 0;

	@AttributeDefinition(name = "Power [W]", description = "Charge/discharge power")
	int power() default 0;

	@AttributeDefinition(name = "Hybrid-ESS Mode", description = "For Hybrid-ESS (ESS with attached DC-side PV system): apply target power to AC or DC side of inverter?")
	HybridEssMode hybridEssMode() default HybridEssMode.TARGET_DC;

	@AttributeDefinition(name = "Cycle Count", description = "How many times should controller do this cycle ?")
	int totalCycleNumber() default 10;

	@AttributeDefinition(name = "Final Soc Value", description = "The Soc value which will be kept in the battery after cycle test completed")
	int finalSoc() default 50;

	@AttributeDefinition(name = "Ess target filter", description = "This is auto-generated by 'Ess-ID'.")
	String ess_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Ess Cycle [{id}]";
}