package io.openems.edge.controller.ess.activepowervoltagecharacteristic;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(//
		name = "Controller Ess Voltage Active Power Characteristic", //
		description = "Defines a active power voltage characteristic for an energy storage system.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlActiveCharacteristic0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Ess-ID", description = "ID of Ess device.")
	String ess_id();

	@AttributeDefinition(name = "Meter-ID", description = "ID of Meter.")
	String meter_id();

	@AttributeDefinition(name = "P by U characteristic ", description = "The graph values for voltage-ratio and power")
	String lineConfig() default "[{ \"voltageRatio\" : 0.95, \"power\" : 4000}, { \"voltageRatio\":0.97999, \"power\": 1000},{ \"voltageRatio\" : 0.98, \"power\" : 0},{ \"voltageRatio\" : 1.0299, \"power\" : 0},{\"voltageRatio\" :1.03 , \"power\": -1000 },{\"voltageRatio\": 1.05 , \"power\": -4000 }]";

	@AttributeDefinition(name = "Nominal Voltage [V]", description = "The nominal voltage of the grid")
	float nominalVoltage() default 240f;

	@AttributeDefinition(name = "Hysteresis [second]", description = "Wait For Hysteresis to Change the Set Power")
	int waitForHysteresis() default 20;

	@AttributeDefinition(name = "Ess target filter", description = "This is auto-generated by 'Ess-ID'.")
	String ess_target() default "(enabled=true)";

	@AttributeDefinition(name = "Meter target filter", description = "This is auto-generated by 'Meter-ID'.")
	String meter_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Ess Voltage Active Power Characteristic [{id}]";
}