package io.openems.edge.controller.api.modbus.readwrite.tcp;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.controller.api.modbus.AbstractModbusTcpApi;

@ObjectClassDefinition(//
		name = "Controller Api Modbus/TCP Read-Write", //
		description = "This controller provides a read-write Modbus/TCP api.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ctrlApiModbusTcp0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "ModbusTcp Read-Write";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Port", description = "Port on which the server should listen.")
	int port() default AbstractModbusTcpApi.DEFAULT_PORT;

	@AttributeDefinition(name = "Component-IDs", description = "Components that should be made available via Modbus.")
	String[] component_ids() default { "_sum" };

	// TODO: Currently unused
	@AttributeDefinition(name = "Read Channel-IDs", description = "Contains the channelnames of all read channels.")
	String[] readChannels() default {};

	@AttributeDefinition(name = "Write Channel-IDs", description = "Contains the channelnames of all overridden channels.")
	String[] writeChannels();

	@AttributeDefinition(name = "Api-Timeout", description = "Sets the timeout in seconds for updates on Channels set by this Api.")
	int apiTimeout() default 60;

	@AttributeDefinition(name = "Max concurrent connections", description = "Sets the maximum number of concurrent connections via Modbus.")
	int maxConcurrentConnections() default AbstractModbusTcpApi.DEFAULT_MAX_CONCURRENT_CONNECTIONS;

	@AttributeDefinition(name = "Components target filter", description = "This is auto-generated by 'Component-IDs'.")
	String Component_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Controller Api Modbus/TCP Read-Write [{id}]";
}