# gprSense® Example Maps — ICAERUS Project

This repository provides example soil moisture maps produced with the **gprSense®** drone-borne radar system as part of the EU-funded **ICAERUS** project (Grant Agreement No. 101060643).

Each subfolder corresponds to one field campaign and contains:
- **Xoptf.txt** – processed radar data file produced by gprSense® (see description below)  
- **.qgz** – QGIS project file containing the map layout and metadata  
- **.png** – exported map image  
- **gprSense_logo.png** – logo required by the QGIS layout for proper rendering  

All datasets are provided for **demonstration and public access** purposes. They showcase the ability of gprSense® to map root-zone soil moisture using off-ground Ground-Penetrating Radar (GPR) and full-wave inverse modeling.

More information about gprSense® is available at [www.gprsense.com](https://www.gprsense.com).

---

### 📄 Description of `Xoptf.txt`

The file `Xoptf.txt`, produced by gprSense®, contains inversion results for each radar trace, with the following columns:

| Column | Description |
|---------|--------------|
| **index** | Trace number (integer identifier) |
| **lat** | Latitude (decimal degrees, WGS84) |
| **lon** | Longitude (decimal degrees, WGS84) |
| **alt** | Antenna altitude (m a.s.l.) |
| **nsat** | Number of GNSS satellites used for position fix |
| **gdop** | Geometric Dilution of Precision (GNSS quality indicator) |
| **lidar** | LiDAR-measured antenna height above ground (m) |
| **h1** | Estimated radar height above ground obtained from inversion (m) |
| **epsr** | Estimated relative permittivity of the subsurface |
| **topp** | Volumetric soil moisture (m³/m³) estimated using Topp’s equation |
| **phi** | Value of the inversion objective function (lower values indicate better fit) |

Note:
The Xoptf.txt format shown above corresponds to the most recent gprSense® (v1.0.0) data structure.
Some earlier maps in this repository may include fewer or slightly different columns, reflecting earlier development versions.

---

### 📄 License

This repository is released under the **Creative Commons Attribution 4.0 International (CC BY 4.0)** license.  
You are free to share and adapt the material provided that appropriate credit is given.

**Please cite:**

*Sébastien Lambot, Université catholique de Louvain & Sensar Consulting, 2025.*  
The development and demonstration of **gprSense®** were supported by the **ICAERUS** project (*Grant Agreement No. 101060643*) through their Open Calls, funded by the European Union’s Horizon Europe research and innovation program, with additional support from the **DuraTechFarm** project (*Contract No. D65-7390, Région Wallonne, Belgium*) for field access and complementary measurements.

---

### 💡 Notes
- Each `.qgz` file can be opened directly in **QGIS ≥ 3.30** to explore and export the maps.  
- All necessary files are included in each folder, so they can be downloaded and opened independently.  
- The data illustrate typical soil moisture mapping performance of the gprSense® radar under real agricultural conditions.
