# **The Prime-Wave Duality:Fixed Geometric Rules Governing the Prime Sequence**

## **📜 Project Overview**

This repository contains the full source code and analysis supporting the paper: **"The Prime-Wave Duality:Fixed Geometric Rules Governing the Prime Sequence"** by Allen Proxmire.

This work reframes the study of prime numbers by translating the consecutive sequence Pn, Pn+1 into an angular time-series signal ∆α. Our empirical analysis, derived from the first 78,498 primes, challenges the stochastic view of primes by demonstrating a fundamental, measurable, wave-like coherence.

## **🔑 Key Findings (The Prime-Wave Duality)**

The analysis confirms the existence of two structural forces that govern the prime distribution:

1. **Global Determination (Asymptotic Ideal):** The systematic bias, or **Global Drift**, of the prime path decays by a factor of over 2x, proving the sequence is under long-range pressure to self-correct toward the 45 degrees **Asymptotic Ideal** (zero drift).  
2. **Local Coherence (Fixed Wave Modes):** The ∆α signal is not noise but contains three specific, dominant, and **invariant spectral peaks** (Fixed Wave Modes). These modes act as a **behavioral protocol**, constraining local prime generation to specific, quantized structural rules.

| Spectral Mode | Frequency (f) | Structural Cycle (Period in Steps) |
| :---- | :---- | :---- |
| **Fast Mode** | 0.47871 | 2.089 |
| **Mid Mode** | 0.38895 | 2.571 |
| **Slow Mode** | 0.35153 | 2.845 |

## **🛠️ Repository Contents & Reproducibility**

Note		Formal documentation and philosophical argument.
Python Code	Reproduces the fixed wave mode frequencies and calculates the Global Drift decay.
README		Project summary

### **How to Reproduce the Findings**

To verify the Local Coherence (Fixed Wave Modes), you only need Python and the NumPy, Matplotlib, and SciPy libraries.

1. Clone this repository.  
2. Run the main script: python prime\_wave\_final\_analysis.py  
3. The script will generate primes up to 1,000,000, perform the geometric transformation, apply the Windowed FFT, and output a CSV file detailing the Global Drift and the exact frequencies of the top five spectral peaks.

## **🔗 Citation and Further Reading**

The full paper is available here:

* **\https://github.com/allen-proxmire/prime-wave-duality/blob/main/Prime%20Wave%20Duality_Note.pdf\]**  
* **\[Insert Zenodo DOI Link Here\]**