# SchengenData

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.16883949.svg)](https://doi.org/10.5281/zenodo.16883949)

Dataset on Schengen exceptions as CSV. Derived from PDF source at: https://home-affairs.ec.europa.eu/policies/schengen/schengen-area/temporary-reintroduction-border-control_en

**Dataset from 2025-10-24**

Under the Schengen Borders Code (SBC), it is possible for Member States to temporarily reintroduce border control at internal borders in the event of a serious threat to public policy or internal security.

The Member States must inform the European Commission when they do this and depending on which article of SBC they use, this comes with different limitations on duration and advance notification.

In essence, all internal border restrictions are temnporary, need justification and the commission must be notified. The European Commission in turn makes these notifications public, unfortunately not as a dataset but as a HTML table for active notifications and a PDF that collects all notifications received from 2006 onwards.

This dataset takes the data from these two sources and publishes them as CSV with the following fields:

| Field | Type | Description |
| :--- | :---: | :--- |
| NB | INT | Entry number |
| MSCC | ISOCC | ISO3166-3 Country Code of Member state |
| Member State | TEXT | Full name of Member State |
| Start | ISODATE | Start date of internal border control |
| End |  ISODATE | End date of internal border control |
| Duration | DAYS | Number of days between start and end |
| Reason/Scope/ | TEXT | Full text of the justification by the Member State |
| CC1-n | ISOCC | ISO3166-3 Country Codes of internal borders affected by the individual notification |

Dataset compiled and curated by Jan Wildeboer. Dataset published here and as DOI under [CC0](https://creativecommons.org/public-domain/cc0/) as Open CData, so free to use in any way, no need to credit or mention the source, though doing that is of course always welcomed :)