# How to Contribute to CloudnetPy

First off, thanks for taking the time to contribute! :+1:

## Reporting bugs

- Create a new [issue](https://github.com/actris-cloudnet/cloudnetpy/issues)
- Describe the problem and steps to reproduce it
- Suggest a fix if you can but this is not mandatory

## Proposing code improvements

If you have a good idea how to improve the code without changing the actual outcome
of the processing, you can directly create a [pull request](https://github.com/actris-cloudnet/cloudnetpy/pulls) (PR).
Examples of these kinds of changes are, for example, better

- implementations of the helper functions
- docstrings, type hints, variable names etc.
- unit tests

Try to keep your pull requests small. This will increase the chance to be accepted.

## Proposing new features

Changes that would alter the actual outcome of the processing need to be carefully
reviewed and tested before accepting. Examples include, for example, modifications in the

- methodology (e.g. replacing the wet bulb method with a newer version)
- threshold values used in different functions / methods
- constant values

Also, for these kinds of proposals, you can open a new [issue](https://github.com/actris-cloudnet/cloudnetpy/issues)
where the idea can be discussed before (possible) implementation.
