# \# Data from: Enantioselective Synthesis of 3-Alkyl-1,5-Functionalized-1,4-Diynes via Isoxazol-5(4H)-ones 

# 

# 1H NMR, 13C NMR and DEPT (when available) spectra are used to describe the structure of all new compounds prepared in the publication: Enantioselective Synthesis of 3-Alkyl-1,5-Functionalized-1,4-Diynes via Isoxazol-5(4H)-ones.

# HPLC traces are used to determine the enantiomeric excesses of chiral compounds syntehsized in this publication

# 

# \## Description of the data and file structure

# 

# Data for each compound are included in a folder named with the compound number designated in the manuscript and/or SI, as “compound number.zip”:

# 

# \* compound\_3aa.zip

# \* compound\_3ab.zip

# \* compound\_3ad.zip

# \* compound\_3ae.zip

# \* compound\_3af.zip

# \* compound\_3ag.zip

# \* compound\_3ah.zip

# \* compound\_3ba.zip

# \* compound\_3bb.zip

# \* compound\_3bc.zip

# \* compound\_3bf.zip

# \* compound\_3ca.zip

# \* compound\_3da.zip

# \* compound\_3ea.zip

# \* compound\_3fb.zip

# \* compound\_3fc.zip

# \* compound\_3fd.zip

# \* compound\_3ff.zip

# \* compound\_3gc.zip

# \* compound\_4aa.zip

# \* compound\_4ab.zip

# \* compound\_4ad.zip

# \* compound\_4ae.zip

# \* compound\_4ah.zip

# \* compound\_4ba.zip

# \* compound\_4bf.zip

# \* compound\_4cc.zip

# \* compound\_4da.zip

# \* compound\_4ea.zip

# \* compound\_4fd.zip

# \* compound\_4ga.zip

# \* compound\_4gc.zip

# \* compound\_4gd.zip

# \* compound\_5.zip

# 

# 

# Each zip folder contains different sub-folders containing data for 1H NMR (named 1H), 13C NMR (named 13C) and DEPT (named DEPT, when available) spectra, and HPLC (named HPLC), respectively, for the compound indicated in the file name. Sub-folders 1H, 13C and DEPT include files that contain the raw NMR data (fid) and other files indicating acquisition and processing parameters and spectrum data. Data in JCAMP-DX open file format are also provided within each sub-folder. These files are named as proton.jdx, carbon.jdxp and dept.jdx (when available). Accessing this data will allow users to view NMR spectra interactively. 

# 

# Subfolder HPLC contains traces of High Performance Liquid Chromatography analysis corresponding to chiral compounds (file named as "HPLC\_EN") and their racemic forms (file named as "HPLC\_RAC"). Files are in pdf format

# 

# \*\*Abbreviations used are as follows:\*\*

# 

# NMR: nuclear magnetic resonance

# 

# HPLC: High Performance Liquid Chromatography

# 

# SI: supporting information (meaning, Supplementary Materials document)

# 

# \### File "structures\_compounds\_3-5.pdf"  contain the structures of compounds 3, compounds 4 and compound 5

# 

# 

# 

# \## Sharing/access Information

# 

# NMR spectra and HPLC traces will be available as images in the SI for this manuscript 

# 

# \## Code/Software

# 

# Processed files with extension .fid are ready to be viewed in NMRViewJ or MestReNova.

# 

# Files with extension .jdx can be readed and processed with unlicensed software such as JSpecView, ACD/Labs NMR Processor or free online viewers such as NMRium

