# Configuration file for the Sphinx documentation builder.

import sys
from pathlib import Path

from pkg_resources import get_distribution

sys.path.insert(0, Path("../../src").resolve().as_posix())
sys.path.append(Path("extensions").resolve().as_posix())

project = "pygama"
copyright = "2023, the LEGEND Collaboration"
version = get_distribution("pygama").version

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.mathjax",
    "sphinx.ext.napoleon",
    "sphinx.ext.intersphinx",
    "sphinx_copybutton",
    "sphinx_inline_tabs",
    "nbsphinx",
    "myst_parser",
    "IPython.sphinxext.ipython_console_highlighting",
    "numbadoc",
]

source_suffix = {
    ".rst": "restructuredtext",
    ".md": "markdown",
}
master_doc = "index"

# Furo theme
html_theme = "furo"
html_theme_options = {
    "source_repository": "https://github.com/legend-exp/pygama",
    "source_branch": "main",
    "source_directory": "docs/source",
}
html_title = f"{project} {version}"
html_logo = "../../.github/logo.png"

# sphinx-napoleon
# enforce consistent usage of NumPy-style docstrings
napoleon_numpy_docstring = True
napoleon_google_docstring = False
napoleon_use_ivar = True
napoleon_use_rtype = False
napoleon_custom_sections = ["JSON Configuration Example"]


# intersphinx
intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "numpy": ("https://numpy.org/doc/stable", None),
    "numba": ("https://numba.readthedocs.io/en/stable", None),
    "scipy": ("https://docs.scipy.org/doc/scipy", None),
    "pandas": ("https://pandas.pydata.org/docs", None),
    "matplotlib": ("https://matplotlib.org/stable", None),
    "h5py": ("https://docs.h5py.org/en/stable", None),
    "pint": ("https://pint.readthedocs.io/en/stable", None),
    "lgdo": ("https://legend-pydataobj.readthedocs.io/en/stable", None),
    "dspeed": ("https://dspeed.readthedocs.io/en/stable", None),
    "daq2lh5": ("https://legend-daq2lh5.readthedocs.io/en/stable", None),
}

suppress_warnings = [
    # "histogram" is defined both in pygama.dsp.processors.histogram.histogram
    # and in pygama.math.histogram, leading to a Sphinx cross-referencing
    # warning.  I don't know how to fix this properly
    "ref.python",
]

# sphinx-autodoc
autodoc_default_options = {"ignore-module-all": True}
# Include __init__() docstring in class docstring
autoclass_content = "both"
autodoc_typehints = "description"
autodoc_typehints_description_target = "documented_params"
autodoc_typehints_format = "short"

# nbsphinx
nbsphinx_epilog = """
----

This page has been automatically generated by nbsphinx_ and can be run as a
Jupyter_ notebook available in the `pygama repository
<https://github.com/legend-exp/pygama/tree/main/docs/source/notebooks>`_.

.. _nbsphinx: https://nbsphinx.readthedocs.io/
.. _Jupyter: https://jupyter.org/
"""
