plantiSMASH - Plant Specialized Metabolite Analysis Shell

===================================================================

[![DOI](https://zenodo.org/badge/185329393.svg)](https://doi.org/10.5281/zenodo.15412176) 
[![bio.tools](https://img.shields.io/static/v1?label=bio.tools&message=plantiSMASH&color=green)](https://bio.tools/plantismash)
[![PyPI - Version](https://img.shields.io/pypi/v/plantismash?label=PyPI&logo=pypi&logoColor=white&include_prereleases)](https://pypi.org/project/plantismash/)
[![GitHub Release](https://img.shields.io/github/v/release/plantismash/plantismash?include_prereleases&sort=semver&display_name=tag&logo=github)](https://github.com/plantismash/plantismash/releases)



**plantiSMASH** is a specialized extension of [antiSMASH](https://antismash.secondarymetabolites.org/) for the identification and analysis of biosynthetic gene clusters (BGCs) in plant genomes. It supports advanced plant-specific detection rules and features for comparative genomics, visualization, and more.

## 📚 Documentation & Wiki

- 🔍 **User documentation**: [plantismash.github.io/documentation](https://plantismash.github.io/documentation/) 
- 🔧 **Installation manual**: available in the [documentation](https://plantismash.github.io/documentation/install/)
- 🧠 **Developer & technical wiki**: [GitHub Wiki](https://github.com/plantismash/plantismash/wiki)


---

## 📄 Publications & Citation

If you use plantiSMASH in your work, please cite the relevant antiSMASH and plantiSMASH publications:

- How to cite the antiSMASH suite of tools: [antiSMASH citations page](http://antismash.secondarymetabolites.org/#!/about)
- PlantiSMASH publications:  
  
**plantiSMASH: automated identification, annotation and expression analysis of plant biosynthetic gene clusters.**  
Satria A. Kautsar, Hernando G Suarez Duran, Kai Blin, Anne Osbourn & Marnix H. Medema
Nucleic Acids Research, 45(W1), W55-W63. (2017) [https://doi.org/10.1093/nar/gkx305](https://doi.org/10.1093/nar/gkx305)

---

## 🔓 License

plantiSMASH is open source software, distributed under the **GNU Affero General Public License** version 3.0 or later. See the [`LICENSE.txt`](LICENSE.txt) file for full terms.

---

## 🤝 Contributing

Interested in contributing or reporting bugs? See our [contributing guidelines](https://github.com/plantismash/plantismash/wiki) or open an issue on the [GitHub Issues page](https://github.com/plantismash/plantismash/issues).

---

## ✉️ Contact

For questions, suggestions, or collaborations, feel free to contact the maintainers via GitHub or reach out to the [plantiSMASH team](mailto:plantismash@bioinformatics.nl).

---

## Acknowledgements
----------------

Some icons used courtesy of [fontawesome.com](fontawesome.com)
