
import pandas as pd, numpy as np, matplotlib.pyplot as plt
df = pd.read_csv('data/trajectories/step_logs_100Hz.csv')
cycles = pd.read_csv('data/trajectories/cycle_index.csv')
seeds = pd.read_csv('data/summaries/per_cycle_metrics_seeds.csv')
tmin = df['time_min'].values; seg_id = df['soil_segment_id'].values
fig, ax1 = plt.subplots(figsize=(14,7), dpi=160)
ax1.set_title('Adaptation Trajectories over 20 Minutes (10 Hz)'); ax1.set_xlabel('Time [min]'); ax1.set_ylabel('Beliefs / SoC (unitless)')
low = df['soil_belief_mean'] - 2*df['soil_belief_std']; high = df['soil_belief_mean'] + 2*df['soil_belief_std']
ax1.fill_between(tmin, low, high, alpha=0.25, label='Soil belief (±2σ)')
ax1.plot(tmin, df['soil_true'], lw=1.2, label='Soil ground truth')
ax1.plot(tmin, df['soil_belief_mean'], lw=1.2, ls='--', label='Soil belief mean')
ax1.plot(tmin, df['accumulator_SoC'], lw=1.0, label='Accumulator SoC')
ax1.scatter(tmin[::500], df['boom_open_norm'].values[::500], s=6, alpha=0.6, label='Boom opening (norm)')
ax1.scatter(tmin[::500], df['arm_open_norm'].values[::500], s=6, alpha=0.6, marker='x', label='Arm opening (norm)')
ax2 = ax1.twinx(); ax2.set_ylabel('Pump Pressure [MPa]')
pump = df['pump_setpoint_MPa'].values
pump_rm = pd.Series(pump).rolling(50, min_periods=1, center=True).mean().to_numpy()
ax2.plot(tmin, pump, lw=0.8, alpha=0.8, label='Pump setpoint')
ax2.plot(tmin, pump_rm, lw=1.6, label='Pump setpoint (rolling mean)')
for k in range(seg_id.max()+1):
    mask = (seg_id==k)
    if mask.any():
        ax1.axvspan(tmin[mask][0], tmin[mask][-1], alpha=0.06)
h1,l1 = ax1.get_legend_handles_labels(); h2,l2 = ax2.get_legend_handles_labels()
ax1.legend(h1+h2, l1+l2, loc='upper right', ncol=2, frameon=True); ax1.grid(True, alpha=0.25)
plt.tight_layout(); plt.savefig('fig6_from_csv.png')
fig, ax3 = plt.subplots(figsize=(14,7), dpi=160)
ax3.set_title('Per-cycle Trajectories across Seeds (Composite View)')
ax3.set_xlabel('Cycle index'); ax3.set_ylabel('Energy per cycle [kJ]')
group = seeds.groupby('cycle_index')
energy_mean = group['energy_kJ'].mean().values
energy_low = group['energy_kJ'].quantile(0.025).values
energy_high = group['energy_kJ'].quantile(0.975).values
ax3.fill_between(np.arange(len(energy_mean)), energy_low, energy_high, alpha=0.25, label='Energy 95% band')
ax3.plot(energy_mean, lw=1.6, label='Energy mean')
ax4 = ax3.twinx(); ax4.set_ylabel('Cycle time [s] / Precision rate [%]')
ctime_mean = group['cycle_time_s'].mean().values
ctime_low = group['cycle_time_s'].quantile(0.025).values
ctime_high = group['cycle_time_s'].quantile(0.975).values
ax4.plot(ctime_mean, lw=1.2, ls='--', label='Cycle time mean')
ax4.fill_between(np.arange(len(ctime_mean)), ctime_low, ctime_high, alpha=0.15, label='Cycle time 95% band')
prec_mean = group['precision_pass'].mean().values * 100.0
ax4.step(np.arange(len(prec_mean)), prec_mean, where='mid', lw=1.2, label='Precision mean')
ax3.grid(True, alpha=0.25)
h3,l3 = ax3.get_legend_handles_labels(); h4,l4 = ax4.get_legend_handles_labels()
ax3.legend(h3+h4, l3+l4, loc='upper right', ncol=2, frameon=True)
plt.tight_layout(); plt.savefig('fig7_from_csv.png')
