/*
  * Copyright 2025 IKERLAN and BArcelona SUpercomputing Center - Centro Nacional de Supercomputacion (BSC-CNS)
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */





#include "rclcpp/rclcpp.hpp"
#include "smw_contention_guard/contention_guard.hpp"
#include "smw_util/thread_utilities.hpp"

int main(int argc, char * argv[])
{
  rclcpp::init(argc, argv);
  rclcpp::executors::SingleThreadedExecutor default_executor;
  rclcpp::executors::SingleThreadedExecutor enable_executor;
  rclcpp::executors::SingleThreadedExecutor pmu_executor;

  auto cguard = std::make_shared<smw_contention_guard::ContentionGuard>();

  default_executor.add_callback_group(
    cguard->getDefaultCallbackGroup(), cguard->get_node_base_interface());
  pmu_executor.add_callback_group(
    cguard->getTimerCallbackGroup(), cguard->get_node_base_interface());
  enable_executor.add_callback_group(
    cguard->getEnableCallbackGroup(), cguard->get_node_base_interface());

  auto default_thread = std::thread([&]() { default_executor.spin(); });

  auto enable_thread = std::thread([&]() { enable_executor.spin(); });

  auto pmu_thread = std::thread([&]() { pmu_executor.spin(); });

  std::vector<int64_t> cpu_set = cguard->getCpuSet();
  smw_util::configure_thread(default_thread, smw_util::ThreadPriority::HIGH, cpu_set);
  smw_util::configure_thread(enable_thread, smw_util::ThreadPriority::HIGH, cpu_set);
  smw_util::configure_thread(pmu_thread, smw_util::ThreadPriority::LOW, cpu_set);

  enable_thread.join();
  pmu_thread.join();

  rclcpp::shutdown();
  return 0;
}