/*
 * Copyright 2025 IKERLAN and BArcelona SUpercomputing Center - Centro Nacional de Supercomputacion (BSC-CNS)
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef SMW_CONTENTION_GUARD__NON_CRITICAL_APPLICATION_HPP
#define SMW_CONTENTION_GUARD__NON_CRITICAL_APPLICATION_HPP

#include <memory>

#include "rclcpp/rclcpp.hpp"
#include "smw_base_application/base_application.hpp"
#include "smw_comm/service_skeleton.hpp"
#include "smw_interfaces/msg/cg_feedback.hpp"
#include "smw_interfaces/msg/pmu_counters.hpp"
#include "smw_util/a78ae-pmu.h"
// #include "contention_guard/pmu_kernel.hpp"

namespace smw_contention_guard
{
class NonCriticalApplication : public smw_base_application::BaseApplication
{
  using CallbackReturn = rclcpp_lifecycle::node_interfaces::LifecycleNodeInterface::CallbackReturn;
  using State = rclcpp_lifecycle::State;
  using CGFeedback = smw_interfaces::msg::CGFeedback;
  using PMUCounters = smw_interfaces::msg::PMUCounters;

public:
  explicit NonCriticalApplication(const std::string & name);
  // virtual ~NonCriticalApplication() noexcept override;
  auto getFeedbackCallbackGroup() const noexcept { return feedback_cb_group_; }
  auto getThrottleCallbackGroup() const noexcept { return throttle_cb_group_; }
  auto getPmuCallbackGroup() const noexcept { return pmu_cb_group_; }
  auto getAliveCallbackGroup() const noexcept { return alive_cb_group_; }

  bool configurePmu() override;
  void pmuReset();

protected:
  CallbackReturn on_configure(const State & state) override final;
  CallbackReturn on_shutdown(const State & state) override final;

  void beforeRun() override;
  void afterRun() override;
  bool disable_performance_monitoring_ = true;

private:
  std::shared_ptr<rclcpp::Subscription<CGFeedback>> feedback_sub_;
  std::unique_ptr<smw_comm::ServiceSkeleton<PMUCounters>> pmu_pub_sk_;
  // std::shared_ptr<rclcpp::Publisher<PMUCounters>> pmu_pub_;

  std::shared_ptr<rclcpp::TimerBase> pmu_timer_;
  std::shared_ptr<rclcpp::TimerBase> non_critical_timer_;
  std::shared_ptr<rclcpp::TimerBase> throttle_timer_;
  std::shared_ptr<rclcpp::TimerBase> alive_timer_;

  std::shared_ptr<rclcpp::CallbackGroup> feedback_cb_group_;
  std::shared_ptr<rclcpp::CallbackGroup> throttle_cb_group_;
  std::shared_ptr<rclcpp::CallbackGroup> pmu_cb_group_;
  std::shared_ptr<rclcpp::CallbackGroup> alive_cb_group_;

  void feedbackCallback(std::shared_ptr<CGFeedback> msg);
  void pmuCallback();
  void nonCriticalCallback();
  void throttleCallback();
  void aliveCallback();

  bool is_throttling = false;
  // unsigned pmc_state = 0;

  // dataset_ *pDs;
  // unsigned iters;

  std::chrono::system_clock::time_point before_run_time_, after_run_time_;
  std::chrono::system_clock::time_point time_pmu_sent, time_throttle_enter;
};
}  // namespace smw_contention_guard

#endif  // SMW_CONTENTION_GUARD__NON_CRITICAL_APPLICATION_HPP
