/*
 * Copyright 2025 IKERLAN and BArcelona SUpercomputing Center - Centro Nacional de Supercomputacion (BSC-CNS)
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 #ifndef SMW_CONTENTION_GUARD__CRITICAL_APPLICATION_HPP
#define SMW_CONTENTION_GUARD__CRITICAL_APPLICATION_HPP

#include <chrono>
#include <memory>

#include "rclcpp/rclcpp.hpp"
#include "smw_base_application/base_application.hpp"
#include "smw_interfaces/msg/cg_enable.hpp"
// #include "contention_guard/pmu_kernel.hpp"

namespace smw_contention_guard
{
class CriticalApplication : public smw_base_application::BaseApplication
{
  using CallbackReturn = rclcpp_lifecycle::node_interfaces::LifecycleNodeInterface::CallbackReturn;
  using State = rclcpp_lifecycle::State;
  using CGEnable = smw_interfaces::msg::CGEnable;

public:
  explicit CriticalApplication(const std::string & name);
  // virtual ~CriticalApplication() noexcept override;

protected:
  CallbackReturn on_configure(const State & state) override final;
  void beforeRun() override;
  void afterRun() override;

private:
  std::shared_ptr<rclcpp::Publisher<CGEnable>> cguard_pub_;
  CGEnable cguard_msg_;

  std::chrono::system_clock::time_point before_run_time_, after_run_time_;

  // dataset_ *pDs;
  // unsigned iters;
};
}  // namespace smw_contention_guard

#endif  // SMW_CONTENTION_GUARD__CRITICAL_APPLICATION_HPP
