
/*
 * Copyright 2025 IKERLAN and BArcelona SUpercomputing Center - Centro Nacional de Supercomputacion (BSC-CNS)
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 #ifndef SMW_CONTENTION_GUARD__CONTENTION_GUARD_HPP
#define SMW_CONTENTION_GUARD__CONTENTION_GUARD_HPP

#include <chrono>
#include <memory>

#include "rclcpp/rclcpp.hpp"
#include "smw_comm/service_proxy.hpp"
#include "smw_contention_guard/contention_function.hpp"
#include "smw_interfaces/msg/cg_enable.hpp"
#include "smw_interfaces/msg/cg_feedback.hpp"
#include "smw_interfaces/msg/pmu_counters.hpp"

namespace smw_contention_guard
{
class ContentionGuard final : public smw_base_application::BaseApplication
{
  using CallbackReturn = rclcpp_lifecycle::node_interfaces::LifecycleNodeInterface::CallbackReturn;
  using State = rclcpp_lifecycle::State;
  using CGEnable = smw_interfaces::msg::CGEnable;
  using CGFeedback = smw_interfaces::msg::CGFeedback;
  using PMUCounters = smw_interfaces::msg::PMUCounters;

public:
  ContentionGuard();
  // ~ContentionGuard() override;

  bool initialize() override;
  bool run() override;
  bool terminate() override;

  std::shared_ptr<rclcpp::CallbackGroup> getDefaultCallbackGroup() noexcept
  {
    return get_node_base_interface()->get_default_callback_group();
  }
  std::shared_ptr<rclcpp::CallbackGroup> getEnableCallbackGroup() const noexcept
  {
    return enable_cb_group_;
  }

private:
  std::shared_ptr<smw_comm::ServiceProxy<PMUCounters>> pmu_proxy_;
  std::shared_ptr<rclcpp::Subscription<CGEnable>> enable_sub_;

  std::shared_ptr<rclcpp::Publisher<CGFeedback>> feedback_pub_;

  void enableCallback(std::shared_ptr<CGEnable> msg);

  void decideState();

  std::shared_ptr<rclcpp::CallbackGroup> enable_cb_group_;
  std::shared_ptr<rclcpp::CallbackGroup> pmu_cb_group_;

  std::unique_ptr<ContentionFunctionL3> contention_function_;
  CGFeedback last_feedback_;

  bool cg_enabled_ = false;
  bool contention_detected_ = false;
};
}  // namespace smw_contention_guard

#endif  // SMW_CONTENTION_GUARD__CONTENTION_GUARD_HPP