/*
 * Copyright 2025 IKERLAN and BArcelona SUpercomputing Center - Centro Nacional de Supercomputacion (BSC-CNS)
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 #ifndef SMW_CONTENTION_GUARD__CONTENTION_FUNCTION_HPP
#define SMW_CONTENTION_GUARD__CONTENTION_FUNCTION_HPP

#include <memory>

#include "smw_interfaces/msg/pmu_counters.hpp"

namespace smw_contention_guard
{
class ContentionFunctionInterface
{
public:
  using PMUCounters = smw_interfaces::msg::PMUCounters;
  virtual ~ContentionFunctionInterface() noexcept = default;
  virtual bool check(const std::unique_ptr<PMUCounters> & msg) = 0;

private:
  virtual bool pmuHasBeenReset(const std::unique_ptr<PMUCounters> & msg) = 0;
};

class ContentionFunctionL3 final : public ContentionFunctionInterface
{
public:
  ContentionFunctionL3(const uint32_t & threshold);
  bool check(const std::unique_ptr<PMUCounters> & msg);
  double getLastBandwidth();

  static const unsigned L2D_CACHE_LMISS_RD = 0;
  static const unsigned L2D_CACHE_WB = 1;
  static const unsigned CPU_CYCLES = 2;

private:
  bool pmuHasBeenReset(const std::unique_ptr<PMUCounters> & msg);
  uint32_t threshold_;
  uint32_t l2d_misses_, l2d_write_backs_, cpu_cycles_;
  static const long int cpu_clock_freq_ = 2201600000;
  double l3_bwidth_ = 0;
};
}  // namespace smw_contention_guard

#endif  // SMW_CONTENTION_GUARD__CONTENTION_FUNCTION_HPP
