# Good Questions, Better Survey Data: Introduction to Effective Questionnaire Design

These open educational resources (OER) provide training materials for an introductory workshop on questionnaire design, tailored to researchers from all disciplines and career stages. The materials are intended for participants with little or no prior experience in questionnaire design.

The workshop has been delivered and evaluated twice in two 6 hours long online training sessions and follows a lecture-style format with embedded interactive exercises. 

**Topics covered**:

- Importance of a well-designed questionnaire
- Characteristics of a well-designed questionnaire
- Introduction to measurement theory
- Types of questions and response scales
- Questionnaire structure and layout
- Challenges and pretesting
- Using existing instruments
- Ethics and data protection
- Documentation
- A guide on getting started

**About the project**

This workshop was developed and delivered within the framework of the **DataNord** project at the **Data Science Center of the University of Bremen**. The DataNord project is funded under the grant number 16DKZ2026A by the Federal Ministry of Research, Technology and Space (BMFTR) and financed by the European Union – NextGenerationEU. 

It is part of a broader initiative to strengthen data literacy among researchers by offering practical, hands-on training in core areas of 1) data science, 2) research data management (RDM), 3) critical thinking, and 4) ethical, legal and social aspects (ELSA). 

Designing high-quality survey questionnaires is a critical skill that directly influences the quality, usability, and reusability of research data. 

Well-constructed survey instruments ensure that data collected are valid, reliable, and analytically meaningful—requirements that underpin all subsequent data science activities, from basic descriptive statistical analysis to machine learning applications. 
The workshop also addresses essential aspects of research data management (RDM) by highlighting the importance of documenting the questionnaire development process. Participants learn how to version their instruments, record key design decisions, and prepare basic metadata to ensure that the resulting data are FAIR. By embedding RDM concepts into questionnaire design, the workshop fosters responsible data creation from the start. 
The training helps researchers to develop a critical and informed approach to survey-based data collection. Participants are encouraged to question seemingly neutral design decisions and to reflect on how wording, layout, sequencing, and social context can influence responses. Through exercises and examples, they learn to identify bias and sources of error, evaluate trade-offs in instrument design, and consider the impact of their methodological choices on data interpretation. 
Finally, the workshop fosters awareness of ethical risks such as bias, harm, and discrimination, while also addressing legal responsibilities related to data protection, copyright and Good Scientific Practice. 

**Included materials**:

- Workshop slides as PowerPoint (with speaking notes) and PDF
- Workshop announcement for participants (text for outreach and preparation)
- Teaching script (trainer notes and session guidance)
- Exercise descriptions (including format, duration, preparation and instructions)

**Important Note on Licensing**:

This OER is licensed under Creative Commons Attribution 4.0 International (CC BY 4.0) unless otherwise noted.

Third-party content such as images, memes, comics, screenshots or reused OER material is not covered by the CC license of this workshop materials. These items are used for non-commercial educational purpose with explicit attribution. For reuse or publication of this third-party material, please ensure to check the license status of each individual item.
