import os
from scrapy.pipelines.files import FilesPipeline
from urllib.parse import urlparse
from os.path import basename, dirname, join


class CustomFilesPipeline(FilesPipeline):
    def file_path(self, request, response=None, *, info=None, item=None):
        spider_id = request.meta.get('id', 'default_id')
        parsed_url = urlparse(request.url)
        filename = os.path.basename(parsed_url.path)

        clean_filename = filename.replace(':', '_').replace('?', '_').replace('&', '_').replace('%', '_')

        if spider_id is not None:
            return join(str(spider_id), clean_filename)
        else:
            info.spider.logger.error("Spider ID is not set.")
            return clean_filename
