# Water balance data fusion
 This repository provides a tool for water balance data fusion of a river basin, i.e.:
 * estimating errors (bias and noise) in ground/satellite-based hydrological observations of the terrestrial water balance (precipitation, evaporation, total water storage, and river discharge)
 without the need for any ground-truth;
 * bias-correcting and noise-filtering the original observations to create a hydrologically consistent dataset of "cleaned" observations that close the water balance.

 The resulting datasets include uncertainty estimates and can for example be used for (spatially lumped) calibration and evaluation of hydrological models using evaporation and total 
 water storage observations, in addition to river discharge data. 
 The methodology is described and applied in this paper:

 Schoups, G., & Nasseri, M. (2021). GRACEfully closing the water balance: a data-driven probabilistic approach applied to river basins in Iran. 
 Water Resources Research, 57, e2020WR029071, https://doi.org/10.1029/2020WR029071.

## How to use
1. Download and install .NET: https://dotnet.microsoft.com/download
2. Clone or download this repository to a local folder
3. Open a terminal/console and navigate to the local folder containing the repository
4. Run the program by typing `dotnet run <basinFolder>` in the terminal/console, where `<basinFolder>` is path of the directory containing the basin data files. 
   For example, to run the analysis for the Mond river basin in Iran (included as example in the `basins` subfolder), type `dotnet run basins/Mond`. 
   Output is written to `results*` files in the same basin folder and consist of monthly estimates of each water balance variable. 
   Each estimate takes the form of a normal distribution written as `Gaussian(mean, variance)`.
5. To run your own river basin, create a new folder, e.g. basins/MyBasin, and add the necessary input files: 
	* two precipitation time-series (PObs1, PObs2)
	* a time-series of precipitation standard errors (PStd)
	* two evaporation time-series (EObs1, EObs2)
	* a river discharge time-series (QObs)
	* a total water storage time-series (SObs)
	* all data are monthly in units of mm
	* missing data: -99999 (SObs); any negative number (all other data)
	* file names for all datasets are specified in fileNames.txt (second column)
	See the example in `basins/Mond`.

## Structure of the code (C#)
 * `Program.cs` reads input files, runs inference, and writes output files to the appropriate basin folder.
 * `WaterBalanceDataFusion_EP_MCMC.cs` contains implementation of the probabilistic water balance model in Infer.NET and code for running MCMC.
 * `WaterBalanceDataFusion_EP.cs` contains code generated by the Infer.NET compiler for computing water balance posteriors.

The code relies on the Infer.NET probabilistic programming library (https://github.com/dotnet/infer), 
which is downloaded automatically (as nuget package) when the program is run for the first time.