import {Coordinate, Polygon} from "@/types/index";


export type FieldType = 'text'|'integer'|'decimal'|'dropdown'

export type Properties = {[key: string]: string}


export interface PropertyConfiguration {
    variable: string
    name: string
    property_type: FieldType
    min_value: number
    max_value: number
    default_value: number
    options: string[]
    unit: string
}


export interface ObjectProcess {
    label: string
    type: string
    sub_type: string
    area_layer: number
}


export interface ObjectReport {
    label: string
    values: string[]
}


export interface ObjectConfiguration {
    id: number
    name: string
    image: string
    max_num: string
    type: string
    min_dist: number
    max_dist: number
    min_area: number
    max_area: number
    properties: PropertyConfiguration[]
    processes: ObjectProcess[]
}

export interface DrawingToolConfiguration {
    name: string
    group_label: string
    submit_label: string
    max_num_per_user: number
    objects: ObjectConfiguration
}

export interface DrawnObject {
    index: number
    dialogObjId: number
    coord: Coordinate
    polygon: Polygon[]
    properties: Properties
}

export interface ObjectGroup {
    id: number
    name: string
    objects: DrawnObject[]
    report: ObjectReport[]
}