# Generated by Django 4.2.13 on 2024-09-27 08:17

from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import metadata.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('main', '0031_alter_author_created_by_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('given_name', models.CharField(max_length=100)),
                ('family_name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('orcid', models.CharField(max_length=100, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='DataFormat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('mime_type', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='License',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='MetadataRecord',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_path', models.CharField(max_length=4000, unique=True, validators=[metadata.models.validate_file_path])),
                ('dataset_path', models.CharField(blank=True, max_length=4000, null=True)),
                ('geonetwork_uuid', models.UUIDField(blank=True, null=True)),
                ('publish_record', models.BooleanField(default=False, help_text='If a record is published, it will be visible without needing to be logged in to Geonetwork')),
                ('doi', models.CharField(blank=True, max_length=32, null=True)),
                ('request_doi', models.BooleanField(default=False, help_text='A DOI can only be requested for public records')),
                ('passed_doi_preconditions', models.CharField(blank=True, help_text='When a DOI is requested, it will be checked for compliance before accepting.', max_length=4000, null=True)),
                ('doi_request_approved', models.BooleanField(default=False)),
                ('record_id', models.CharField(blank=True, max_length=32, null=True, unique=True)),
                ('version', models.CharField(blank=True, help_text='Changing this field will overwrite any previous version. For a new version, create a new Metadata Record.', max_length=12, null=True)),
                ('language', models.CharField(choices=[(None, ''), ('bg', 'Bulgarian'), ('cs', 'Czech'), ('da', 'Danish'), ('nl', 'Dutch'), ('en', 'English'), ('et', 'Estonian'), ('fi', 'Finnish'), ('de', 'German'), ('el', 'Greek'), ('fr', 'French'), ('hr', 'Croatian'), ('hu', 'Hungarian'), ('it', 'Italien'), ('ga', 'Irish'), ('lv', 'Latvian'), ('lt', 'Lithuanian'), ('mt', 'Maltese'), ('pl', 'Polish'), ('pt', 'Portuguese'), ('ro', 'Romanian'), ('sk', 'Slovak'), ('sl', 'Slovenian'), ('es', 'Spanish'), ('sv', 'Swedish')], default='en', max_length=20, null=True)),
                ('title', models.CharField(max_length=200)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('published_at', models.DateField(blank=True, null=True)),
                ('abstract', models.TextField(max_length=4000)),
                ('keywords', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=1000, null=True), blank=True, default=list, null=True, size=None)),
                ('bucket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.bucket')),
                ('format', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='metadata.dataformat')),
                ('license', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='metadata.license')),
            ],
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=1000)),
                ('ror', models.CharField(max_length=100, unique=True)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='MetadataRecordAuthor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='metadata.author')),
                ('record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='metadata.metadatarecord')),
            ],
        ),
        migrations.AddField(
            model_name='metadatarecord',
            name='publisher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='metadata.organization'),
        ),
        migrations.AddField(
            model_name='author',
            name='affiliation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='metadata.organization'),
        ),
        migrations.AddField(
            model_name='author',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
    ]
