from django.http import HttpResponse  # noqa
from django.shortcuts import get_object_or_404  # noqa

from main.models import StaEndpoint, StaLayer  # noqa
from .sta.StaApi import StaApi
from .sta.RequestBuilder import RequestBuilder



def get_sta_locations(request, sta_layer_id: int):

    sta_layer = get_object_or_404(StaLayer, id=sta_layer_id)

    api = StaApi(sta_layer.endpoint)

    builder = RequestBuilder(request)
    builder.build_thing_queries(sta_layer)

    response = None

    if builder.bbox_url:
        response = api.get_response(builder.bbox_url)
    if not response or response.status_code == 500:
        # Bounding-Box probably not supported by STA-Endpoint
        response = api.get_response(builder.basic_url)
    return HttpResponse(response, content_type = "application/json")



def get_obs_properties(request, sta_layer_id: int):

    sta_layer = get_object_or_404(StaLayer, id=sta_layer_id)

    api = StaApi(sta_layer.endpoint)
    builder = RequestBuilder(request)

    return api.get_json_response(builder.get_property_query(sta_layer))



def get_thing(request, sta_endpoint_id: int, thing_id: int):

    endpoint = get_object_or_404(StaEndpoint, id=sta_endpoint_id)

    url = 'v1.1/Things?$filter=id eq {}'.format(thing_id)

    api = StaApi(endpoint)
    return api.get_json_response(url)



def get_obs_properties_by_thing(request, sta_layer_id: int, thing_id: int):

    sta_layer = get_object_or_404(StaLayer, id=sta_layer_id)

    api = StaApi(sta_layer.endpoint)
    builder = RequestBuilder(request)

    return api.get_json_response(builder.get_property_query_by_thing(sta_layer, thing_id))



def get_datastream_properties(request, sta_endpoint_id: int, thing_id: int, obs_property_id: int):
    endpoint = get_object_or_404(StaEndpoint, id=sta_endpoint_id)

    url = 'v1.1/Datastreams?$filter=ObservedProperty/id eq {} and Thing/id eq {}&$select=unitOfMeasurement/symbol&$expand=ObservedProperty'.format(
        obs_property_id,
        thing_id
    )

    api = StaApi(endpoint)
    return api.get_json_response(url)



def get_all_datastreams(request, sta_endpoint_id: int, thing_id: int, obs_property_id: int):
    endpoint = get_object_or_404(StaEndpoint, id=sta_endpoint_id)

    url = 'v1.1/Observations?$filter=Datastream/ObservedProperty/id eq {} and Datastream/Thing/id eq {}&$select=result,resultTime&$orderby=resultTime asc'.format(
        obs_property_id,
        thing_id
    )

    api = StaApi(endpoint)
    return api.get_json_response(url)
