import requests
from django.http import HttpResponse    # noqa

from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry  # noqa

from main.models import StaEndpoint  # noqa


class StaApi:

    def __init__(self, endpoint: StaEndpoint):
        retry_strategy = Retry(
            total=3,
            backoff_factor=2,
            allowed_methods=['DELETE', 'GET', 'HEAD', 'OPTIONS', 'PUT', 'POST']
        )
        adapter = HTTPAdapter(max_retries=retry_strategy)

        self.session = requests.Session()
        self.session.mount("https://", adapter)
        self.session.mount("http://", adapter)

        self.endpoint = endpoint


    def get_response(self, url: str):
        url = self.endpoint.base_url + url

        try:
            return self.session.get(url, auth=(self.endpoint.username, self.endpoint.password), timeout=15)
        except Exception:
            return HttpResponse("Cannot request STA {}".format(url), status=500)



    def get_json_response(self, url: str):
        return HttpResponse(self.get_response(url), content_type="application/json")
