from django.http import HttpResponse # noqa
from django.shortcuts import get_object_or_404 # noqa
from django.template import loader  # noqa
from django.urls import reverse # noqa
from django.shortcuts import redirect   # noqa

from metadata.models import MetadataRecord # noqa
from main.lib.s3_utils import get_minio_download_link, get_s3_filesystem, list_minio_folder # noqa


def get_download_overview(request, record_id, page_number: int = 0):

    metadata_record = get_object_or_404(MetadataRecord, record_id=record_id)

    if not metadata_record.is_published:
        return redirect(reverse('adminDownloadOverview', kwargs={'record_id': record_id, 'page_number': page_number}))

    return get_download_page(request, record_id, page_number)


def get_download_page(request, record_id, page_number: int = 0):


    page_number = int(page_number)
    first_page_item_index = page_number if page_number == 0 else (page_number * 10)

    metadata_record = get_object_or_404(MetadataRecord, record_id=record_id)

    bucket_name = metadata_record.bucket.name
    files = []
    data_files = list_minio_folder(bucket_name, metadata_record.dataset_path)

    is_end_of_files = False
    for i, file in enumerate(data_files):
        if i >= first_page_item_index:
            files.append({
                'absolute_path': bucket_name + '/' + file.object_name,
                'relative_path': file.object_name,
                'download_link': get_minio_download_link(bucket_name, file.object_name),
                'size': get_file_size(file.size)
            })
            if i >= first_page_item_index + 9:
                break
    try:
        data_files.__next__()
    except StopIteration:
        is_end_of_files = True

    metadata_filename = metadata_record.title + '_' + str(metadata_record.geonetwork_uuid)

    template = loader.get_template('download.html')

    if page_number > 0:
        prev_page = reverse('downloadOverview', kwargs={'record_id': record_id, 'page_number': page_number - 1 })
    else:
        prev_page = None

    if not is_end_of_files:
        next_page = reverse('downloadOverview', kwargs={'record_id': record_id, 'page_number': page_number + 1})
    else:
        next_page = None

    context = {
        'title': metadata_record.title,
        'filename': metadata_filename,
        'files': files,
        'prev_page': prev_page,
        'next_page': next_page
    }
    return HttpResponse(template.render(context, request))


def get_file_size(size: int):
    if size > 999999999999:
        div = pow(1024, 4)
        unit = "TB"
    elif size > 999999999:
        div = pow(1024, 3)
        unit = "GB"
    elif size > 999999:
        div = pow(1024, 2)
        unit = "MB"
    elif size > 9999:
        div = 1024
        unit = "KB"
    else:
        div = 1.024
        unit = "B"
    return str(round((size / div), 2)) + " " + unit


def get_uncertainty(request, file_path):
    s3 = get_s3_filesystem()
    try:
        s3_file = s3.open(file_path, mode='rb')
        return HttpResponse(s3_file)
    except FileNotFoundError:
        return HttpResponse("Cannot find file: {}".format(file_path), status=404)
