import os
import json
import requests
from django.http import HttpResponse, JsonResponse  # noqa
from django.shortcuts import get_object_or_404  # noqa

from main.models import AreaLayer, Process  # noqa
from main.lib.AggregationApi import AggregationApi  # noqa

from django.views.decorators.csrf import csrf_exempt  # noqa


def get_countries(request):
    with open("main/geojson/countries/2_hoch.geo.json") as f:
        data = json.load(f)
    return JsonResponse(data)


def get_districts_by_country(request, country_id):
    with open("main/geojson/districts/{}_admin.geojson".format(country_id)) as f:
        data = json.load(f)
    return JsonResponse(data)


@csrf_exempt
def request_aggregation_values(request):
    body = json.loads(request.body)
    api = AggregationApi(os.environ.get("AGGREGATION_API_URL"))

    area_layer = get_object_or_404(AreaLayer, id=body['layer_id'])
    layer = area_layer.wms_layer

    process = get_object_or_404(Process, type=body['process_type'], sub_type=body['process_sub_type'])

    if layer is not None:

        if not body['time_steps']:
            body['time_steps'] = layer.time_steps

        cache_result = api.get_cache(layer, process, body['polygon'], body['time_steps'])
        if cache_result is not None:
            cache_result['status'] = True
            return JsonResponse(cache_result)

        try:
            results = api.call_process(layer, process, body['polygon'], body['time_steps'])
            results['status'] = True
            return JsonResponse(results)
        except requests.exceptions.ConnectionError:
            return HttpResponse("Cannot request PyGeoApi.", status=504)
        except Exception as e:
            print(e)

    return HttpResponse('Process throws an error: {}, {}, Polygon: {}'.format(layer, process, body['polygon']), status=500)
