# Generated by Django 4.2.23 on 2025-08-26 15:02

from django.db import migrations
from django.apps import apps


from ..models import Area, Category, SubCategory, SubCategoryLayer, AreaLayer


def migrate_list_filters(apps, _schema_editor):

    ListFilter = apps.get_model('main', 'listfilter')

    for list_filter in ListFilter.objects.all():

        area = Area.objects.get(id=list_filter.area.id)
        category = Category(
            name_de = list_filter.name_de,
            name_en = list_filter.name_en,
            area = area,
            is_active = list_filter.is_active,
            position = list_filter.position
        )
        category.save()

    ListFilterItem = apps.get_model('main', 'listfilteritem')


    for list_filter_item in ListFilterItem.objects.all():

        area = Area.objects.get(id=list_filter_item.list_filter.area.id)

        sub_category = SubCategory(
            name_de = list_filter_item.name_de,
            name_en = list_filter_item.name_en,
            category = Category.objects.get(area=area, name_de=list_filter_item.list_filter.name_de)
        )
        sub_category.save()

    LayerListFilterItem = apps.get_model('main', 'layerlistfilteritem')

    for layer_list_filter_item in LayerListFilterItem.objects.all():

        area = Area.objects.get(id=layer_list_filter_item.filter_item.list_filter.area.id)

        category = Category.objects.get(area=area,
                                        name_de=layer_list_filter_item.filter_item.list_filter.name_de)

        layer = AreaLayer.objects.get(id=layer_list_filter_item.layer.id)

        sub_category_layer = SubCategoryLayer(
            layer = layer,
            sub_category = SubCategory.objects.get(name_de=layer_list_filter_item.filter_item.name_de, category=category),
        )
        sub_category_layer.save()


class Migration(migrations.Migration):

    dependencies = [
        ('main', '0065_category_subcategory_subcategorylayer_and_more'),
    ]

    operations = [
        migrations.RunPython(
            migrate_list_filters,
            migrations.RunPython.noop
        ),
    ]