# Generated by Django 4.2.13 on 2024-08-12 15:04

import datetime
from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import main.models
from metadata.models import validate_file_path


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('main', '0027_project_print_annotation_de_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('given_name', models.CharField(max_length=100)),
                ('family_name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('orcid', models.CharField(max_length=100, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='DataFormat',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='License',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='MetadataRecord',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_path', models.CharField(max_length=4000, unique=True, validators=[validate_file_path])),
                ('dataset_path', models.CharField(blank=True, max_length=4000, null=True)),
                ('geonetwork_uuid', models.UUIDField(blank=True, null=True)),
                ('doi', models.CharField(blank=True, max_length=32, null=True)),
                ('record_id', models.CharField(blank=True, max_length=32, null=True, unique=True)),
                ('version', models.CharField(blank=True, max_length=12, null=True)),
                ('language', models.CharField(choices=[(None, ''), ('bul', 'Bulgarian'), ('cze', 'Czech'), ('dan', 'Danish'), ('dut', 'Dutch'), ('eng', 'English'), ('est', 'Estonian'), ('fin', 'Finnish'), ('ger', 'German'), ('gre', 'Greek'), ('fre', 'French'), ('hrv', 'Croatian'), ('hun', 'Hungarian'), ('ita', 'Italien'), ('gle', 'Irish'), ('lav', 'Latvian'), ('lit', 'Lithuanian'), ('mlt', 'Maltese'), ('pol', 'Polish'), ('por', 'Portuguese'), ('rum', 'Romanian'), ('slo', 'Slovak'), ('slv', 'Slovenian'), ('spa', 'Spanish'), ('swe', 'Swedish')], default='eng', max_length=20, null=True)),
                ('title', models.CharField(max_length=200)),
                ('created', models.DateField(blank=True, null=True)),
                ('updated', models.DateField(default=datetime.date.today)),
                ('published', models.DateField(blank=True, null=True)),
                ('abstract', models.TextField(max_length=4000)),
                ('keywords', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=1000, null=True), blank=True, default=list, null=True, size=None)),
            ],
        ),
        migrations.RemoveField(
            model_name='filerecord',
            name='data_files',
        ),
        migrations.AddField(
            model_name='bucket',
            name='wms_file_suffix',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='abstract',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='created',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='dataset_path',
            field=models.CharField(blank=True, max_length=4000, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='doi',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='format',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='keywords',
            field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=100, null=True), blank=True, default=list, null=True, size=None),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='language',
            field=models.CharField(blank=True, max_length=12, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='license',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='published',
            field=models.DateField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='title',
            field=models.CharField(blank=True, max_length=4000, null=True),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='updated',
            field=models.DateField(default=datetime.date.today),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='version',
            field=models.CharField(blank=True, max_length=12, null=True),
        ),
        migrations.AddField(
            model_name='wmslayer',
            name='file_path',
            field=models.CharField(blank=True, max_length=4000, null=True),
        ),
        migrations.AlterField(
            model_name='geojsonlayer',
            name='file_record',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.filerecord'),
        ),
        migrations.AlterField(
            model_name='geojsonlayer',
            name='time_format',
            field=models.CharField(blank=True, choices=[('month', 'month'), ('period-19', 'period-19-years (from start-year)'), ('period-29', 'period-29-years (from center-year)'), ('period-49', 'period-49-years (from center-year)'), ('season', 'season'), ('year', 'year')], max_length=20, null=True),
        ),
        migrations.AlterField(
            model_name='stalayer',
            name='time_format',
            field=models.CharField(blank=True, choices=[('month', 'month'), ('period-19', 'period-19-years (from start-year)'), ('period-29', 'period-29-years (from center-year)'), ('period-49', 'period-49-years (from center-year)'), ('season', 'season'), ('year', 'year')], max_length=20, null=True),
        ),
        migrations.AlterField(
            model_name='wmslayer',
            name='file_record',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.filerecord'),
        ),
        migrations.AlterField(
            model_name='wmslayer',
            name='time_format',
            field=models.CharField(blank=True, choices=[('month', 'month'), ('period-19', 'period-19-years (from start-year)'), ('period-29', 'period-29-years (from center-year)'), ('period-49', 'period-49-years (from center-year)'), ('season', 'season'), ('year', 'year')], max_length=20, null=True),
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=1000)),
                ('ror', models.CharField(max_length=100, unique=True)),
                ('created_by', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='MetadataRecordAuthor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.author')),
                ('record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.metadatarecord')),
            ],
        ),
        migrations.AddField(
            model_name='metadatarecord',
            name='bucket',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.bucket'),
        ),
        migrations.AddField(
            model_name='metadatarecord',
            name='format',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.dataformat'),
        ),
        migrations.AddField(
            model_name='metadatarecord',
            name='license',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.license'),
        ),
        migrations.AddField(
            model_name='metadatarecord',
            name='publisher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.organization'),
        ),
        migrations.AddField(
            model_name='author',
            name='affiliation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.organization'),
        ),
        migrations.AddField(
            model_name='author',
            name='created_by',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='filerecord',
            name='publisher',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.organization'),
        ),
    ]
