# Generated by Django 4.2.11 on 2024-03-20 14:55

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import main.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('main', '0020_bucket_public_folder_alter_bucket_name_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='bucket',
            name='quota',
            field=models.IntegerField(default=10, validators=[django.core.validators.MinValueValidator(1)], verbose_name='Quota'),
        ),
        migrations.AddField(
            model_name='bucket',
            name='size_unit',
            field=models.CharField(choices=[('ki', 'KB'), ('mi', 'MB'), ('gi', 'GB'), ('ti', 'TB')], default='g', max_length=20, verbose_name='Unit'),
        ),
        migrations.CreateModel(
            name='S3User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, validators=[main.models.validate_bucket_name])),
                ('ldap_dn', models.CharField(blank=True, max_length=100, null=True, unique=True)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BucketUser',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('has_write_permission', models.BooleanField(default=True)),
                ('is_bucket_admin', models.BooleanField(default=False)),
                ('bucket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.bucket')),
                ('s3user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.s3user')),
            ],
        ),
        migrations.AddConstraint(
            model_name='bucketuser',
            constraint=models.UniqueConstraint(fields=('s3user', 'bucket'), name='unique_bucket_user'),
        ),
    ]
