# Generated by Django 4.1.7 on 2023-09-22 14:25

import colorfield.fields
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Area',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('position', models.IntegerField(default=1)),
                ('is_active', models.BooleanField(default=True)),
                ('info_de', models.TextField(blank=True, null=True)),
                ('info_en', models.TextField(blank=True, null=True)),
                ('is_default_on_start', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='AreaLayer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.IntegerField(default=1)),
                ('is_active', models.BooleanField(default=False)),
                ('area', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.area')),
            ],
        ),
        migrations.CreateModel(
            name='Bucket',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('geonetwork_group', models.IntegerField(blank=True, null=True)),
                ('connect_to_geoserver', models.BooleanField(default=False)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
            ],
        ),
        migrations.CreateModel(
            name='BucketEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event_time', models.DateTimeField()),
                ('event_data', models.JSONField()),
                ('job_status', models.IntegerField(blank=True, null=True)),
                ('logs', models.CharField(blank=True, max_length=4000, null=True)),
                ('is_new', models.BooleanField(default=False, null=True)),
                ('has_metadata_record', models.BooleanField(default=False, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DataVariable',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=1000)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
            ],
        ),
        migrations.CreateModel(
            name='FileRecord',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('geonetwork_uuid', models.UUIDField(blank=True, null=True)),
                ('file_path', models.CharField(max_length=4000, unique=True)),
                ('data_files', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=4000), null=True, size=None, unique=True)),
                ('file_identifier', models.CharField(blank=True, max_length=32, null=True, unique=True)),
                ('bucket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.bucket')),
            ],
        ),
        migrations.CreateModel(
            name='ListFilter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('position', models.IntegerField(default=1)),
                ('is_active', models.BooleanField(default=True)),
                ('area', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.area')),
            ],
            options={
                'verbose_name': 'List-Filter',
                'verbose_name_plural': 'List-Filter',
            },
        ),
        migrations.CreateModel(
            name='Process',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('type', models.CharField(choices=[('aggregation', 'aggregation'), ('process', 'process'), ('magnitude', 'magnitude'), ('anomaly', 'anomaly')], max_length=20)),
                ('sub_type', models.CharField(max_length=100, unique=True)),
                ('spatial_aggregation_type', models.CharField(blank=True, max_length=32, null=True)),
                ('temporal_aggregation_type', models.CharField(blank=True, max_length=32, null=True)),
            ],
            options={
                'verbose_name': 'Process',
                'verbose_name_plural': 'Processes',
            },
        ),
        migrations.CreateModel(
            name='StaEndpoint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('base_url', models.CharField(max_length=4000)),
                ('username', models.CharField(blank=True, max_length=4000, null=True)),
                ('password', models.CharField(blank=True, max_length=4000, null=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
            ],
        ),
        migrations.CreateModel(
            name='WmsLayer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('info_de', models.TextField(blank=True, null=True)),
                ('info_en', models.TextField(blank=True, null=True)),
                ('time_format', models.CharField(blank=True, choices=[('month', 'month'), ('period', 'period'), ('season', 'season'), ('year', 'year')], max_length=20, null=True)),
                ('y_axis_min', models.DecimalField(blank=True, decimal_places=5, max_digits=12, null=True)),
                ('y_axis_max', models.DecimalField(blank=True, decimal_places=5, max_digits=12, null=True)),
                ('unit_de', models.CharField(blank=True, max_length=4000, null=True)),
                ('unit_en', models.CharField(blank=True, max_length=4000, null=True)),
                ('epsg_code', models.CharField(blank=True, max_length=4000, null=True)),
                ('no_data_value', models.IntegerField(default=-9999)),
                ('axis_label_x', models.CharField(blank=True, max_length=4000, null=True)),
                ('axis_label_y', models.CharField(blank=True, max_length=4000, null=True)),
                ('scale_factor', models.IntegerField(default=1)),
                ('wms_url', models.URLField(max_length=4000, null=True)),
                ('layer_name', models.CharField(max_length=4000)),
                ('time_steps', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=100, null=True), blank=True, default=list, null=True, size=None)),
                ('uncertainty_path', models.CharField(blank=True, max_length=4000, null=True)),
                ('opacity', models.DecimalField(decimal_places=2, default=0.5, max_digits=3)),
                ('file_record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.filerecord')),
                ('variable', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='main.datavariable')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WmsLegend',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=50, unique=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=50, unique=True, verbose_name='Name (en)')),
                ('type', models.CharField(choices=[('discrete', 'discrete'), ('gradient', 'gradient')], default='discrete', max_length=20)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
            ],
        ),
        migrations.CreateModel(
            name='WmsLayerProcess',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('in_cache', models.BooleanField(default=False)),
                ('process', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.process')),
                ('wms_layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.wmslayer')),
            ],
            options={
                'verbose_name': 'WmsLayer-Process-Configuration',
                'verbose_name_plural': 'WmsLayer-Process-Configurations',
            },
        ),
        migrations.CreateModel(
            name='WmsLayerLegend',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('replace_values_in_viewer_by_label', models.BooleanField(default=False)),
                ('position', models.IntegerField(default=1)),
                ('legend', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.wmslegend')),
                ('wms_layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.wmslayer')),
            ],
        ),
        migrations.CreateModel(
            name='WmsColor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('color', colorfield.fields.ColorField(default='#FFFFFF', image_field=None, max_length=18, samples=None)),
                ('position', models.IntegerField(default=1)),
                ('upper_limit', models.DecimalField(decimal_places=6, max_digits=12)),
                ('is_invisible', models.BooleanField(default=False)),
                ('legend', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.wmslegend')),
            ],
        ),
        migrations.CreateModel(
            name='StaLegend',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=1000)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
            ],
        ),
        migrations.CreateModel(
            name='StaLayer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('info_de', models.TextField(blank=True, null=True)),
                ('info_en', models.TextField(blank=True, null=True)),
                ('time_format', models.CharField(blank=True, choices=[('month', 'month'), ('period', 'period'), ('season', 'season'), ('year', 'year')], max_length=20, null=True)),
                ('y_axis_min', models.DecimalField(blank=True, decimal_places=5, max_digits=12, null=True)),
                ('y_axis_max', models.DecimalField(blank=True, decimal_places=5, max_digits=12, null=True)),
                ('datastream', models.CharField(max_length=4000)),
                ('geonetwork_uuid', models.UUIDField(blank=True, null=True)),
                ('endpoint', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.staendpoint')),
                ('legend', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.stalegend')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaColor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('color', colorfield.fields.ColorField(default='#FFFFFF', image_field=None, max_length=18, samples=None)),
                ('position', models.IntegerField(default=1)),
                ('upper_limit', models.DecimalField(decimal_places=6, max_digits=12)),
                ('legend', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.stalegend')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('name_in_url', models.CharField(max_length=100, unique=True)),
                ('name_in_backend', models.CharField(max_length=100, unique=True)),
                ('about_text_de', models.TextField(blank=True, null=True)),
                ('about_text_en', models.TextField(blank=True, null=True)),
                ('imprint_text_de', models.TextField(blank=True, null=True)),
                ('imprint_text_en', models.TextField(blank=True, null=True)),
                ('faq_text_de', models.TextField(blank=True, null=True)),
                ('faq_text_en', models.TextField(blank=True, null=True)),
                ('theme', models.CharField(blank=True, max_length=100, null=True)),
                ('default_lon', models.DecimalField(blank=True, decimal_places=10, max_digits=12, null=True, verbose_name='Longitude')),
                ('default_lat', models.DecimalField(blank=True, decimal_places=10, max_digits=12, null=True, verbose_name='Latitude')),
                ('default_zoom', models.DecimalField(blank=True, decimal_places=8, max_digits=10, null=True)),
                ('maintenance_notification_de', models.CharField(blank=True, max_length=4000, null=True)),
                ('maintenance_notification_en', models.CharField(blank=True, max_length=4000, null=True)),
                ('is_english_version_active', models.BooleanField(default=False)),
                ('bucket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.bucket')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProcessCache',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('polygon_id', models.CharField(max_length=100)),
                ('time_steps', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), size=None)),
                ('results', models.JSONField()),
                ('process', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.process')),
                ('wms_layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.wmslayer')),
            ],
        ),
        migrations.CreateModel(
            name='ListFilterItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name_de', models.CharField(max_length=1000, null=True, verbose_name='Name (de)')),
                ('name_en', models.CharField(max_length=1000, null=True, verbose_name='Name (en)')),
                ('list_filter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.listfilter')),
            ],
            options={
                'verbose_name': 'Filter-Option',
                'verbose_name_plural': 'Filter-Options',
            },
        ),
        migrations.CreateModel(
            name='LayerListFilterItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('filter_item', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.listfilteritem')),
                ('layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.arealayer')),
            ],
            options={
                'verbose_name': 'Connected Layer',
                'verbose_name_plural': 'Connected Layers',
            },
        ),
        migrations.CreateModel(
            name='ConnectedLayer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('timeseries', 'timeseries'), ('single value', 'single value')], default='', max_length=20)),
                ('referenced_wms_layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ref_target_layer', to='main.wmslayer')),
                ('wms_layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ref_layer', to='main.wmslayer')),
            ],
        ),
        migrations.AddField(
            model_name='arealayer',
            name='sta_layer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.stalayer'),
        ),
        migrations.AddField(
            model_name='arealayer',
            name='wms_layer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.wmslayer'),
        ),
        migrations.AddField(
            model_name='area',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.project'),
        ),
        migrations.AddConstraint(
            model_name='wmslayerlegend',
            constraint=models.UniqueConstraint(fields=('wms_layer', 'legend'), name='unique_wms_layer_legend'),
        ),
        migrations.AddConstraint(
            model_name='wmslayerlegend',
            constraint=models.UniqueConstraint(fields=('wms_layer', 'position'), name='unique_wms_legend_pos'),
        ),
        migrations.AddConstraint(
            model_name='wmscolor',
            constraint=models.UniqueConstraint(fields=('legend', 'position'), name='unique_color_pos'),
        ),
        migrations.AddConstraint(
            model_name='wmscolor',
            constraint=models.UniqueConstraint(fields=('legend', 'upper_limit'), name='unique_color_limit'),
        ),
        migrations.AddConstraint(
            model_name='processcache',
            constraint=models.UniqueConstraint(fields=('wms_layer', 'process', 'polygon_id'), name='unique_layer_process_polygon'),
        ),
        migrations.AddConstraint(
            model_name='listfilter',
            constraint=models.UniqueConstraint(fields=('area', 'position'), name='unique_filter_pos'),
        ),
        migrations.AddConstraint(
            model_name='layerlistfilteritem',
            constraint=models.UniqueConstraint(fields=('layer', 'filter_item'), name='unique_layer_list_filter'),
        ),
        migrations.AddConstraint(
            model_name='connectedlayer',
            constraint=models.UniqueConstraint(fields=('wms_layer', 'referenced_wms_layer'), name='unique_connected_wms_layer'),
        ),
        migrations.AddConstraint(
            model_name='arealayer',
            constraint=models.UniqueConstraint(fields=('area', 'position'), name='unique_area_layer'),
        ),
        migrations.AddConstraint(
            model_name='area',
            constraint=models.UniqueConstraint(fields=('project', 'position'), name='unique_area_pos'),
        ),
    ]
