import os
import time
import datetime

from django.db import connections   # noqa
from django.core.management.base import BaseCommand # noqa
from django.db.models import Q  # noqa
from django.db import connections # noqa
from django.db.utils import OperationalError # noqa

from main.lib.s3_utils import download_minio_file # noqa

from data_import.models import CsvImportJob, WFS, STA   # noqa
from ._import import StaImporter, WfsImporter


SIZE_LIMIT = 30000000   # 30 MB

class Command(BaseCommand):

    def handle(self, *args, **options):

        if not has_conn_to_geoserver_database():
            print("Error: Cannot parse CSV. No Connection to Postgis-DB!")
            return

        job = (CsvImportJob.objects.filter(Q(is_processed=False) & Q(is_running=False))
               .select_related('bucket__sta_endpoint', 'bucket__sta_csv_parser', 'bucket__wfs_csv_parser')
               .order_by('created_at').first())

        if not job:
            print("No open CSV-Import-Job.")
        else:
            job.validate_file_size(SIZE_LIMIT)

            if job.validation_error:
                job.is_processed = True
                job.is_success = False
                job.save()
                return

            start_time = time.time()
            job.started_at = datetime.datetime.now()
            job.is_running = True
            job.save()

            file_name = job.s3_file.split('/')[-1]
            download_minio_file(job.bucket.name, job.s3_file, file_name)

            if job.target == STA:
                i = StaImporter(job)
                i.run_import_job(None)

            if job.target == WFS:
                conn = connections["geoserver"].cursor()
                i = WfsImporter(job)
                i.run_import_job(conn)
                conn.close()

            job.execution_time = str(round((time.time() - start_time), 2)) + "s"
            job.finished_at = datetime.datetime.now()
            job.is_processed = True
            job.is_running = False
            job.save()

            os.remove(file_name)


def has_conn_to_geoserver_database():
    conn = connections['geoserver']
    try:
        conn.cursor()
    except OperationalError:
        return False
    return True
