import os

from django.core.management.base import BaseCommand # noqa

from main.lib.s3_utils import upload_file # noqa
from metadata.models import MetadataRecord   # noqa

from ._metadata import create_jsonld_content
from ._api import GeonetworkApi


class Command(BaseCommand):

    def handle(self, *args, **options):

        api = GeonetworkApi()

        for record in MetadataRecord.objects.filter(is_sync_scheduled=True):

            # create Geonetwork-Record

            if record.geonetwork_uuid:
                api.update_record(record)
            else:
                uuid = api.create_record(record)
                record.geonetwork_uuid = uuid

            # create DOI

            if record.is_doi_requested:

                if not record.is_doi_approved:
                    record.is_doi_check_passed = api.check_doi_preconditions(record.geonetwork_uuid)

                elif record.is_doi_approved and not record.doi:
                    doi = api.create_doi(record.geonetwork_uuid)
                    if doi:
                        record.doi = doi

            record.logs = "\n".join(api.logs)
            api.logs = []

            # put JSON-LD into bucket
            try:
                file_name = 'tmp.jsonld'

                with open(file_name, "w") as file:
                    jsonld_formatted = create_jsonld_content(record)

                    file.write(jsonld_formatted)

                    # upload_file(record.bucket.name, record.file_path, file_name)

                    os.remove(file_name)

            except Exception:
                record.logs += "\nCannot create JSON-LD in bucket."

            record.is_sync_scheduled = False
            record.save()


        # delete Records in Geonetwork

        for record in MetadataRecord.objects.filter(is_delete_scheduled=True):
            try:
                api.delete_record(record.geonetwork_uuid)
                record.delete()
            except Exception as e:
                record.logs = 'Could not delete related Geonetwork-Record: ' + str(e)
                record.save()
