from .QueryBuilder import QueryBuilder


class UpdateQueryBuilder(QueryBuilder):

    def get_statements(self):

        stmts = []

        stmt_params = [
            ('min_timerecord', 'min_date', 'MIN'),
            ('max_timerecord', 'max_date', 'MAX'),
        ]

        for params in stmt_params:
            stmts.append("""
                update {feature_table} cf
                    set {col1} = x.aggr_date
                    from (
                        select
                            {aggr_func}(ts.{col2}) as aggr_date,
                            ts.feature_id
                        from {timeseries_table} ts
                        group by ts.feature_id
                    ) as x
                    where cf.id = x.feature_id
                """.format(
                    feature_table=self.feature_table,
                    timeseries_table=self.timeseries_table,
                    col1=params[0],
                    col2=params[1],
                    aggr_func=params[2]
            ))

        stmt_params = [
            ('min_lat', 'lat', 'MIN', '<'),
            ('min_lon', 'lon', 'MIN', '<'),
            ('max_lat', 'lat', 'MAX', '>'),
            ('max_lon', 'lon', 'MAX', '>'),
        ]

        for params in stmt_params:
            stmts.append("""
                update {table_name} cp
                    set {col1} = x.aggr_value
                    from (
                        select {aggr_func}(cast(d.{col2} as double precision)) as aggr_value,
                        property_name
                        from data_import_wfsimportrecord d
                        group by (d.property_name)
                    ) as x
                    where cp.name = x.property_name
                    and x.aggr_value {operator} cp.{col1}
            """.format(
                table_name=self.property_table,
                col1=params[0],
                col2=params[1],
                aggr_func=params[2],
                operator=params[3]
            ))

        stmts.append("""
            update {} cp
                set geom = ST_MakeEnvelope(cp.min_lon, cp.min_lat, cp.max_lon, cp.max_lat),
                gtype = 'Point',
                srid = '4326'
        """.format(
            self.property_table
        ))


        stmt_params = [
            ('min_value', 'cast(d.value as double precision)', 'MIN', '<'),
            ('max_value', 'cast(d.value as double precision)', 'MAX', '>'),
            ('min_date', "to_timestamp(d.date, 'YYYY-MM-DDThh24:mi:ss')::timestamp without time zone at time zone 'Etc/UTC'", 'MIN', '<'),
            ('max_date', "to_timestamp(d.date, 'YYYY-MM-DDThh24:mi:ss')::timestamp without time zone at time zone 'Etc/UTC'", 'MAX', '>'),
        ]

        for params in stmt_params:
            stmts.append("""
                update {timeseries_table} ts
                    set {col1} = x.updated_value
                    from (
                        select {aggr_func}({col2}) as updated_value,
                        d.property_name,
                        d.location_name,
                        cast(d.lat as double precision),
                        cast(d.lon as double precision),
                        d.unit
                        from data_import_wfsimportrecord d
                        group by (
                            d.property_name,
                            d.location_name,
                            d.lat,
                            d.lon,
                            d.unit
                        )
                    ) as x
                    where ts.property_id = (select p.id from {property_table} p where x.property_name = p.name)
                    and ts.feature_id = (select f.id from {feature_table} f where x.location_name = f.name and x.lat = f.lat and x.lon = f.lon)
                    and ts.unit = x.unit
                    and x.updated_value {operator} ts.{col1};
            """.format(
                timeseries_table=self.timeseries_table,
                feature_table=self.feature_table,
                property_table=self.property_table,
                col1=params[0],
                col2=params[1],
                aggr_func=params[2],
                operator=params[3]
            ))

        return stmts
