from abc import ABC, abstractmethod
from data_import.models import CsvParserExtraColumn # noqa


class QueryBuilder(ABC):

    def __init__(self, data_store_name, extra_columns: list[CsvParserExtraColumn]=None):
        self.data_store_name = data_store_name
        self.extra_columns = extra_columns

        self.feature_table = "{}_feature".format(data_store_name)
        self.property_table = "{}_property".format(data_store_name)
        self.timeseries_table = "{}_timeseries".format(data_store_name)
        self.timerecord_table = "{}_timerecord".format(data_store_name)

    @abstractmethod
    def get_statements(self):
        pass