from abc import ABC, abstractmethod

from data_import.models import CsvImportJob, CsvIncludeCriteria, STA, WFS # noqa


class Importer(ABC):

    def __init__(self, job: CsvImportJob):
        self.job = job
        self.logs = []
        if job.target == STA:
            self.include_criteria = CsvIncludeCriteria.objects.filter(parser=job.bucket.sta_csv_parser)
        elif job.target == WFS:
            self.include_criteria = CsvIncludeCriteria.objects.filter(parser=job.bucket.wfs_csv_parser)

    @abstractmethod
    def run_import_job(self, conn):
        pass

    def get_file_name(self):
        return self.job.s3_file.split('/')[-1]

    def is_row_included(self, row) -> bool:

        if len(self.include_criteria) > 0:
            for criteria in self.include_criteria:
                if row[criteria.col_num] == criteria.text_value:
                    return True
            return False
        else:
            return True